technique Water

{

pass Pass0

{

VertexShader = compile vs_2_0 WaterVS();

PixelShader = compile ps_2_0 WaterPS();

}

}


    struct WaterVertexToPixel
    {

    float4 Position : POSITION;

    float4 ReflectionMapSamplingPos : TEXCOORD1;

    float2 BumpMapSamplingPos : TEXCOORD2;

    float4 RefractionMapSamplingPos : TEXCOORD3;

    float4 Position3D : TEXCOORD4;

    };


    struct WaterPixelToFrame

    {

    float4 Color : COLOR0;

    };


WaterVertexToPixel WaterVS(float4 inPos : POSITION, float2 inTex: TEXCOORD)

{

WaterVertexToPixel Output = (WaterVertexToPixel)0;

float44 preViewProjection = mul (xView, xProjection);

float44 preWorldViewProjection = mul (xWorld, preViewProjection);

float44 preReflectionViewProjection = mul (xReflectionView, xProjection);

float44 preWorldReflectionViewProjection = mul (xWorld, preReflectionViewProjection);

Output.Position = mul(inPos, preWorldViewProjection);



Output.ReflectionMapSamplingPos = mul(inPos, preWorldReflectionViewProjection);

Output.RefractionMapSamplingPos = mul(inPos, preWorldViewProjection);

return Output;

}


WaterPixelToFrame WaterPS(WaterVertexToPixel PSIn)

{

ProjectedTexCoords.x = PSIn.ReflectionMapSamplingPos.x/PSIn.ReflectionMapSamplingPos.w/2.0f + 0.5f;

ProjectedTexCoords.y = PSIn.ReflectionMapSamplingPos.y/PSIn.ReflectionMapSamplingPos.w/2.0f + 0.5f;

float4 reflectiveColor = tex2D(ReflectionSampler, perturbatedTexCoords);



ProjectedRefrTexCoords.x = PSIn.RefractionMapSamplingPos.x/PSIn.RefractionMapSamplingPos.w/2.0f + 0.5f;

ProjectedRefrTexCoords.y = -PSIn.RefractionMapSamplingPos.y/PSIn.RefractionMapSamplingPos.w/2.0f + 0.5f;

float4 refractiveColor = tex2D(RefractionSampler, perturbatedRefrTexCoords);

return Output;

}


    private RenderTarget2D reflectionRenderTarg;
    private Texture2D reflectionMap;
    reflectionRenderTarg = new RenderTarget2D(device, 512, 512, 1, SurfaceFormat.Color);
private Matrix reflectionViewMatrix;
float reflectionCamZCoord = -cameraPosition.Z + 2*waterHeight;
Vector3 reflectionCamPosition = new Vector3(cameraPosition.X, cameraPosition.Y, reflectionCamZCoord);

float reflectionTargetZCoord = -targetPos.Z + 2 * waterHeight;
Vector3 reflectionCamTarget = new Vector3(targetPos.X, targetPos.Y, reflectionTargetZCoord);

Vector3 forwardVector = reflectionCamTarget - reflectionCamPosition;
Vector3 sideVector = Vector3.Transform(new Vector3(1, 0, 0), cameraRotation); Vector3 reflectionCamUp = Vector3.Cross(sideVector, forwardVector);

reflectionViewMatrix = Matrix.CreateLookAt(reflectionCamPosition, reflectionCamTarget, reflectionCamUp);
Vector3 planeNormalDirection = new Vector3(0, 0, 1);
planeNormalDirection.Normalize();
Vector4 planeCoefficients = new Vector4(planeNormalDirection, -waterHeight);
Matrix camMatrix = reflectionViewMatrix * projectionMatrix;
Matrix invCamMatrix = Matrix.Invert(camMatrix);
invCamMatrix = Matrix.Transpose(invCamMatrix);
planeCoefficients = Vector4.Transform(planeCoefficients, invCamMatrix);
Plane refractionClipPlane = new Plane(planeCoefficients);
device.ClipPlanes[0].Plane = refractionClipPlane;
private void DrawReflectionMap()
{

Vector3 planeNormalDirection = new Vector3(0, 0, 1);
planeNormalDirection.Normalize();
Vector4 planeCoefficients = new Vector4(planeNormalDirection, -waterHeight);
Matrix camMatrix = reflectionViewMatrix * projectionMatrix;
Matrix invCamMatrix = Matrix.Invert(camMatrix);
invCamMatrix = Matrix.Transpose(invCamMatrix);
planeCoefficients = Vector4.Transform(planeCoefficients, invCamMatrix);
Plane reflectionClipPlane = new Plane(planeCoefficients);
device.ClipPlanes[0].Plane = reflectionClipPlane;
device.ClipPlanes[0].IsEnabled = true;
device.SetRenderTarget(0, reflectionRenderTarg);
device.Clear(ClearOptions.Target | ClearOptions.DepthBuffer, Color.Black, 1.0f, 0);
DrawTerrain(reflectionViewMatrix);
DrawSkyDome(reflectionViewMatrix);
device.ResolveRenderTarget(0);
reflectionMap = reflectionRenderTarg.GetTexture();
device.SetRenderTarget(0, null);
device.ClipPlanes[0].IsEnabled = false;

}


    RenderTarget2D refractionRenderTarg;
    Texture2D refractionMap;
    refractionRenderTarg = new RenderTarget2D(device, 512, 512, 1, SurfaceFormat.Color);


    Vector3 planeNormalDirection = new Vector3(0, 0, -1);
    planeNormalDirection.Normalize();
    Vector4 planeCoefficients = new Vector4(planeNormalDirection, 5.0f);
    Matrix camMatrix = viewMatrix * projectionMatrix;
    Matrix invCamMatrix = Matrix.Invert(camMatrix);
    invCamMatrix = Matrix.Transpose(invCamMatrix);
    planeCoefficients = Vector4.Transform(planeCoefficients, invCamMatrix);
    Plane refractionClipPlane = new Plane(planeCoefficients);


private void DrawRefractionMap()
{

Vector3 planeNormalDirection = new Vector3(0, 0, -1);
planeNormalDirection.Normalize();
Vector4 planeCoefficients = new Vector4(planeNormalDirection, 5.0f);
Matrix camMatrix = viewMatrix * projectionMatrix;
Matrix invCamMatrix = Matrix.Invert(camMatrix);
invCamMatrix = Matrix.Transpose(invCamMatrix);
planeCoefficients = Vector4.Transform(planeCoefficients, invCamMatrix);
Plane refractionClipPlane = new Plane(planeCoefficients);evice.ClipPlanes[0].Plane = refractionClipPlane;
device.ClipPlanes[0].IsEnabled = true;
device.SetRenderTarget(0, refractionRenderTarg);

device.Clear(ClearOptions.Target | ClearOptions.DepthBuffer, Color.Black, 1.0f, 0);

DrawTerrain();
device.ResolveRenderTarget(0);
refractionMap = refractionRenderTarg.GetTexture();
device.SetRenderTarget(0, null);
device.ClipPlanes[0].IsEnabled = false;

}


if ( fresnelMode == 0 )

{

fresnelTerm = dot(eyeVector, normalVector);

//correction

fresnelTerm = 1-fresnelTerm*1.3f

}


    if ( fresnelMode == 1 )
    {

    fresnelTerm = 0.02f+0.97f*pow((1-dot(eyeVector, normalVector)),5);
    }


    if ( fresnelMode == 2 )
    {

    float fangle = 1+dot(eyeVector, normalVector);

    fangle = pow(fangle ,5);

    fresnelTerm = 1/fangle;
    }


    //Hardness factor  user input
    fresnelTerm = fresnelTerm * xDrawMode;

    //just to be sure that the value is between 0 and 1;
    fresnelTerm = fresnelTerm < 0? 0 : fresnelTerm;
    fresnelTerm = fresnelTerm > 1? 1 : fresnelTerm;

    // creating the combined color
    float4 combinedColor = refractiveColor*(1-fresnelTerm) + reflectiveColor*(fresnelTerm);


    private Texture2D waterBumpMap;
    waterBumpMap = content.Load (waterbump);
    effect.Parameters[xWaterBumpMap].SetValue(waterBumpMap);elapsedTime += (float)gameTime.ElapsedGameTime.Milliseconds / 100000.0f;
    effect.Parameters[xTime].SetValue(elapsedTime);
Texture xWaterBumpMap;Texture xWaterBumpMap;
sampler WaterBumpMapSampler = sampler_state { texture = ; magfilter = LINEAR; minfilter = LINEAR; mipfilter=LINEAR; AddressU = mirror; AddressV = mirror;};


    struct WaterVertexToPixel
    {

    float4 Position : POSITION

    float4 ReflectionMapSamplingPos : TEXCOORD1;

    float2 BumpMapSamplingPos : TEXCOORD2;

    

    };

    
    float2 moveVector = float2(0, 1);
    Output.BumpMapSamplingPos = inTex/xWaveLength + xTime*xWindForce*moveVector;
float4 bumpColor = tex2D(WaterBumpMapSampler, PSIn.BumpMapSamplingPos);
float2 perturbation = xWaveHeight*(bumpColor.rg  0.5f);
float2 perturbatedTexCoords = ProjectedTexCoords + perturbation;


    float4 reflectiveColor = tex2D(ReflectionSampler, perturbatedTexCoords);
    float4 refractiveColor = tex2D(RefractionSampler, perturbatedRefrTexCoords);
Vector4 planeCoefficients = new Vector4(planeNormalDirection, -waterHeight+1.0f);
float4 dullColor = float4(0.1f, 0.1f, 0.2f, 1.0f);
float dullBlendFactor = xdullBlendFactor;
Output.Color = (dullBlendFactor*dullColor + (1-dullBlendFactor)*combinedColor);
float4 speccolor;
float3 lightSourceDir = normalize(float3(0.1f,0.6f,0.5f));
float3 halfvec = normalize(eyeVector+lightSourceDir+float3(perturbation.x*specPerturb,perturbation.y*specPerturb,0));
float3 temp = 0;
temp.x = pow(dot(halfvec,normalVector),specPower);
speccolor = float4(0.98,0.97,0.7,0.6);
speccolor = speccolor*temp.x;
speccolor = float4(speccolor.x*speccolor.w,speccolor.y*speccolor.w,speccolor.z*speccolor.w,0);
Output.Color = Output.Color + speccolor;
